<?php

if(isset($_POST['email'])) {

    // EDIT THE 2 LINES BELOW AS REQUIRED
    $email_to = "admissions@successpoint.ae, successpointcollege0@gmail.com";
    $email_subject = "MBA programs Email Inquiry";

    // Validation expected data exists (message is now optional)
    if(!isset($_POST['name']) ||
       !isset($_POST['email']) ||
       !isset($_POST['phone']) ||
       !isset($_POST['program'])) {
        // Redirect to an error page if validation fails
        header("Location: error.html");
        exit();
    }

    $first_name = $_POST['name']; // required
    $email_from = $_POST['email']; // required
    $telephone = $_POST['phone']; // required
    $intrested_in = $_POST['program']; // required
    $comments = isset($_POST['message']) ? $_POST['message'] : ''; // message is optional

    $error_message = "";
    $email_exp = '/^[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/';

    // Email validation
    if(!preg_match($email_exp, $email_from)) {
        $error_message .= 'The Email Address you entered does not appear to be valid.<br />';
    }

    $string_exp = "/^[A-Za-z .'-]+$/";
    // Name validation
    if(!preg_match($string_exp, $first_name)) {
        $error_message .= 'The First Name you entered does not appear to be valid.<br />';
    }

    // Mobile number validation (10 or 12 digits)
    $phone_exp = '/^\d{10}$|^\d{12}$/';
    if(!preg_match($phone_exp, $telephone)) {
        $error_message .= 'The Phone Number you entered must be 10 or 12 digits.<br />';
    }

    if(strlen($error_message) > 0) {
        // Redirect to an error page if validation fails
        header("Location: error.html");
        exit();
    }

    $email_message = "Form details below.\n\n";

    function clean_string($string) {
        $bad = array("content-type", "bcc:", "to:", "cc:", "href");
        return str_replace($bad, "", $string);
    }

    $email_message .= "Name: ".clean_string($first_name)."\n";
    $email_message .= "Email: ".clean_string($email_from)."\n";
    $email_message .= "Phone: ".clean_string($telephone)."\n";
    $email_message .= "Program: ".clean_string($intrested_in)."\n";

    // Append message only if it's not empty
    if(!empty($comments)) {
        $email_message .= "Message: ".clean_string($comments)."\n";
    }

    // Create email headers
    $headers = 'From: '.$email_from."\r\n".
               'Reply-To: '.$email_from."\r\n" .
               'X-Mailer: PHP/' . phpversion();

    @mail($email_to, $email_subject, $email_message, $headers);

    // Redirect to the thank you page after sending email
    header("Location: thankyou.html");
    exit();
}
?>
